from flask import Flask, render_template, jsonify, request
import os
import logging

# Configure logging
logging.basicConfig(level=logging.DEBUG)

app = Flask(__name__)
app.secret_key = os.environ.get("SESSION_SECRET", "dev_key")

# In-memory score storage
high_scores = []

@app.route('/')
def index():
    return render_template('index.html')

@app.route('/api/scores', methods=['GET'])
def get_scores():
    return jsonify(high_scores)

@app.route('/api/scores', methods=['POST'])
def save_score():
    score_data = request.json
    high_scores.append({
        'score': score_data['score'],
        'timestamp': score_data['timestamp']
    })
    high_scores.sort(key=lambda x: x['score'], reverse=True)
    high_scores[:] = high_scores[:10]  # Keep only top 10
    return jsonify({'status': 'success'})

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5000, debug=True)
